<?php

namespace App\Http\Controllers;

use App\Models\ClassRoom;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Excel;
use App\Exports\ExamStudentExport;
use App\Exports\RoomAttendanceExport;

class ExportController extends Controller
{
    private $excel;
    public function __construct(Excel $excel)
    {
        $this->excel = $excel;
    }
    public function attendanceExport($roomId)
    {
        $room = ClassRoom::find($roomId);
        $fileName = ' تقرير الحضور والغياب لطلاب '.$room->name.' دورة '.$room->course->title;
        return $this->excel->download(new RoomAttendanceExport($roomId),$fileName.'.xlsx');
    }
    public function ExamExport($roomId)
    {
        $room = ClassRoom::find($roomId);
        $fileName = ' تقرير   الاختبارات لبرنامج  '.$room->name.' دورة '.$room->course->title;
        return $this->excel->download(new ExamStudentExport($roomId),$fileName.'.xlsx');
    }
}
